/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.auiml.databeans.network.IPBeans;
import com.ibm.hsc.auiml.databeans.network.NameDNSBean;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.websm.launch.hscmgt.NetworkSettings;
import com.ibm.hsc.websm.launch.hscmgt.SystemConfigurationOverview;
import com.ibm.ui.framework.swing.DataBean;
import com.ibm.websm.diagnostics.IDebug;
import java.util.ArrayList;
import java.util.HashMap;

public class HMCModify
implements HMCCommands {
    private static final String NETWORK_PARAM = "network";
    private static final String SSH_PARAM = "ssh";
    private static final String HTTP_PARAM = "http";
    private static final String WEBSM_PARAM = "websm";
    private static final String XNTP_PARAM = "xntp";
    private static final String SYSLOG_PARAM = "syslog";
    private static final String KBDCFG_PARAM = "kbdcfg";
    private static final String ENABLE_PARAM = "enable";
    private static final String DISABLE_PARAM = "disable";
    private static final String ADD_PARAM = "add";
    private static final String REMOVE_PARAM = "remove";
    private static final String MODIFY_PARAM = "modify";
    private static final String ETH0_PARAM = "eth0";
    private static final String ETH1_PARAM = "eth1";
    private Boolean sshSetting;
    private Boolean httpSetting;
    private Boolean websmSetting;
    private Boolean syslogSetting;
    private Boolean kbdcfgSetting;
    private Boolean xntpSetting;
    private boolean modifyXNTP;
    private boolean addConfig;
    private boolean removeConfig;
    private String nameserver;
    private String domainsuffix;
    private String ifnum;
    private int interfaceNum;
    private String ipaddr;
    private String netmask;
    private String ntpversion;
    private String hostname;
    private String domainname;
    private String gateway;
    private static final String[] IF_PARAMS = new String[]{HMCCommandUtils.IPADDR_PARAM, HMCCommandUtils.NETMASK_PARAM};
    private static final String[] MODIFY_PARAMS = new String[]{HMCCommandUtils.HOSTNAME_PARAM, HMCCommandUtils.DOMAINNAME_PARAM, HMCCommandUtils.GATEWAY_PARAM, HMCCommandUtils.INTERFACE_PARAM, HMCCommandUtils.IPADDR_PARAM, HMCCommandUtils.NETMASK_PARAM};
    private static final String[] ADD_REMOVE_PARAMS = new String[]{HMCCommandUtils.NAMESERVER_PARAM, HMCCommandUtils.DOMAINSUFFIX_PARAM};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performCommand() throws HSCException, RequiredParameterException {
        String string = "";
        String string2 = System.getProperty("HMCRealUser.name");
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[]{""};
        if (this.sshSetting != null) {
            SystemConfigurationOverview.doRemoteAccess(this.sshSetting, null);
            stringArray[0] = SystemConfigurationOverview.sshEnabled() != false ? ENABLE_PARAM : DISABLE_PARAM;
            String string3 = "HSCE2109 User name " + string2 + ": Modified remote execution settings to: ssh " + stringArray[0];
            HSCLogUtils.logSystemEvent((short)2109, string3, stringArray, string2);
            return;
        }
        if (this.httpSetting != null) {
            Object object;
            int n;
            block63: {
                n = 0;
                try {
                    if (this.httpSetting.booleanValue()) {
                        stringArray[0] = ENABLE_PARAM;
                        object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings http enable");
                    } else {
                        stringArray[0] = DISABLE_PARAM;
                        object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings http disable");
                    }
                    n = ((Process)object).waitFor();
                }
                catch (Throwable throwable) {
                    if (!IDebug.enabled()) break block63;
                    throwable.printStackTrace();
                }
            }
            if (n == 0) {
                object = "HSCE2178 User name " + string2 + ": Modified web server settings to: " + stringArray[0];
                HSCLogUtils.logSystemEvent((short)2178, (String)object, stringArray, string2);
                return;
            }
            object = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_HTTP_SETTINGS", "An error occured while attempting to change web server settings. Please retry the command.");
            throw new HSCException((String)object);
        }
        if (this.websmSetting != null) {
            Object object;
            int n;
            block64: {
                n = 0;
                try {
                    if (this.websmSetting.booleanValue()) {
                        stringArray[0] = ENABLE_PARAM;
                        object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings websm enable");
                    } else {
                        stringArray[0] = DISABLE_PARAM;
                        object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings websm disable");
                    }
                    n = ((Process)object).waitFor();
                }
                catch (Throwable throwable) {
                    if (!IDebug.enabled()) break block64;
                    throwable.printStackTrace();
                }
            }
            if (n == 0) {
                object = "HSCE2177 User name " + string2 + ": Modified websm server settings to: " + stringArray[0];
                HSCLogUtils.logSystemEvent((short)2177, (String)object, stringArray, string2);
                return;
            }
            object = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_WEBSM_SETTINGS", "An error occured while attempting to change websm server settings. Please retry the command.");
            throw new HSCException((String)object);
        }
        if (this.syslogSetting != null) {
            Object object;
            int n;
            block65: {
                n = 0;
                String string4 = "";
                if (this.ipaddr != null) {
                    string4 = this.ipaddr;
                }
                if (this.hostname != null) {
                    string4 = this.hostname;
                }
                try {
                    object = this.addConfig ? Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings syslog add " + string4) : Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings syslog remove " + string4);
                    n = ((Process)object).waitFor();
                }
                catch (Throwable throwable) {
                    if (!IDebug.enabled()) break block65;
                    throwable.printStackTrace();
                }
            }
            if (n == 0) {
                object = "HSCE2177 User name " + string2 + ": Modified syslog server settings";
                HSCLogUtils.logSystemEvent((short)2179, (String)object, null, string2);
                return;
            }
            object = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYSLOGD_SETTINGS", "An error occured while attempting to change syslog settings.");
            throw new HSCException((String)object);
        }
        if (this.kbdcfgSetting != null) {
            int n = 0;
            try {
                Process process = this.kbdcfgSetting != false ? Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings kbdcfg enable") : Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings kbdcfg disable");
                n = process.waitFor();
                return;
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled()) return;
                throwable.printStackTrace();
            }
            return;
        }
        if (this.xntpSetting != null) {
            Object object;
            String string5;
            int n;
            block66: {
                n = 0;
                String string6 = "";
                string5 = "";
                try {
                    if (this.addConfig || this.removeConfig) {
                        if (this.ntpversion != null) {
                            string6 = this.ntpversion;
                        }
                        if (this.ipaddr != null) {
                            string5 = this.ipaddr;
                        }
                        if (this.hostname != null) {
                            string5 = this.hostname;
                        }
                        object = this.addConfig ? Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp add " + string5 + " " + string6) : Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp remove " + string5 + " " + string6);
                        n = ((Process)object).waitFor();
                    } else {
                        if (this.xntpSetting.booleanValue()) {
                            object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp enable");
                            stringArray[0] = ENABLE_PARAM;
                        } else {
                            object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp disable");
                            stringArray[0] = DISABLE_PARAM;
                        }
                        n = ((Process)object).waitFor();
                    }
                }
                catch (Throwable throwable) {
                    if (!IDebug.enabled()) break block66;
                    throwable.printStackTrace();
                }
            }
            if (n == 0) {
                object = "";
                if (this.addConfig) {
                    object = "HSCE2181 User name " + string2 + ": Modified xntp settings to add " + string5;
                    HSCLogUtils.logSystemEvent((short)2181, (String)object, null, string2);
                    return;
                } else if (this.removeConfig) {
                    object = "HSCE2182 User name " + string2 + ": Modified xntp settings to remove " + string5;
                    HSCLogUtils.logSystemEvent((short)2182, (String)object, null, string2);
                    return;
                } else {
                    object = "HSCE2183 User name " + string2 + ": Modified syslog server settings to" + stringArray[0];
                    HSCLogUtils.logSystemEvent((short)2183, (String)object, stringArray, string2);
                }
                return;
            }
            object = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_XNTP_SETTINGS", "An error occured while attempting to change xntp settings.");
            throw new HSCException((String)object);
        }
        DataBean[] dataBeanArray = NetworkSettings.GetIPSettings();
        IPBeans iPBeans = (IPBeans)dataBeanArray[0];
        NameDNSBean nameDNSBean = (NameDNSBean)dataBeanArray[1];
        if (this.addConfig) {
            if (this.nameserver != null) {
                nameDNSBean.addToList(nameDNSBean.getDNSServersList(), this.nameserver, "DNS");
            }
            if (this.domainsuffix != null) {
                nameDNSBean.addToList(nameDNSBean.getDomainSuffixesList(), this.domainsuffix, "Domain Suffix");
            }
        } else if (this.removeConfig) {
            if (this.nameserver != null && !nameDNSBean.deleteRow(nameDNSBean.getDNSServersList(), this.nameserver, "DNS", false)) {
                Object[] objectArray = new String[]{this.nameserver};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NOT_FOUND_IN_LIST", null, objectArray);
                throw new HSCException(string);
            }
            if (this.domainsuffix != null && !nameDNSBean.deleteRow(nameDNSBean.getDomainSuffixesList(), this.domainsuffix, "DomainSuffix", false)) {
                Object[] objectArray = new String[]{this.domainsuffix};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NOT_FOUND_IN_LIST", null, objectArray);
                throw new HSCException(string);
            }
        } else {
            if (this.hostname != null) {
                iPBeans.setHostName(this.hostname);
            }
            if (this.domainname != null) {
                nameDNSBean.setDomainName(this.domainname);
            }
            if (this.gateway != null) {
                iPBeans.setIPGateway(this.gateway);
            }
            if (this.ipaddr != null) {
                iPBeans.setIPAddr(this.interfaceNum, this.ipaddr);
            }
            if (this.netmask != null) {
                iPBeans.setMask(this.interfaceNum, this.netmask);
            }
        }
        try {
            NetworkSettings.SetIPSettings(iPBeans, nameDNSBean);
            SystemConfigurationOverview.ApacheSetup();
        }
        catch (Exception exception) {
            String string7 = "HSCE2114 User name " + string2 + ": Failed to modify network settings";
            HSCLogUtils.logSystemEvent((short)2114, string7, stringArray, string2);
            throw new HSCException(exception);
        }
        if (this.addConfig || this.removeConfig) {
            String string8;
            String[] stringArray3 = null;
            if (this.nameserver != null) {
                stringArray3 = HMCCommandUtils.getTitles(nameDNSBean.getDNSServersList());
                if (stringArray3 == null) {
                    stringArray3 = stringArray2;
                }
                stringArray[0] = HMCCommandUtils.flattenArray(stringArray3, stringArray3.length);
                string8 = "HSCE2110 User name " + string2 + ": Modified DNS Server search order to: " + stringArray[0];
                HSCLogUtils.logSystemEvent((short)2110, string8, stringArray, string2);
            }
            if (this.domainsuffix == null) return;
            stringArray3 = HMCCommandUtils.getTitles(nameDNSBean.getDomainSuffixesList());
            if (stringArray3 == null) {
                stringArray3 = stringArray2;
            }
            stringArray[0] = HMCCommandUtils.flattenArray(stringArray3, stringArray3.length);
            string8 = "HSCE2111 User name " + string2 + ": Modified Domain Suffix search order to: " + stringArray[0];
            HSCLogUtils.logSystemEvent((short)2111, string8, stringArray, string2);
            return;
        } else {
            String string9;
            if (this.ipaddr != null || this.netmask != null) {
                stringArray[0] = this.ifnum;
                stringArray[1] = iPBeans.getIPAddr(this.interfaceNum);
                if (stringArray[1] == null) {
                    stringArray[1] = "";
                }
                stringArray[2] = iPBeans.getMask(this.interfaceNum);
                if (stringArray[2] == null) {
                    stringArray[2] = "";
                }
                string9 = "HSCE2112 User name " + string2 + ": Modified network settings of interface " + stringArray[0] + " to: IP address " + stringArray[1] + ", Network Mask " + stringArray[2];
                HSCLogUtils.logSystemEvent((short)2112, string9, stringArray, string2);
            }
            if (this.hostname == null && this.domainname == null && this.gateway == null) return;
            stringArray[0] = iPBeans.getHostName();
            if (stringArray[0] == null) {
                stringArray[0] = "";
            }
            stringArray[1] = nameDNSBean.getDomainName();
            if (stringArray[1] == null) {
                stringArray[1] = "";
            }
            stringArray[2] = iPBeans.getIPGateway();
            if (stringArray[2] == null) {
                stringArray[2] = "";
            }
            string9 = "HSCE2113 User name " + string2 + ": Modified network settings to: Host Name " + stringArray[0] + ", Domain Name " + stringArray[1] + ", Default Gateway " + stringArray[2];
            HSCLogUtils.logSystemEvent((short)2113, string9, stringArray, string2);
        }
    }

    private void checkInvalidCombination(HashMap hashMap, String[] stringArray, String string) throws RequiredParameterException {
        int n = 0;
        while (n < stringArray.length) {
            if (hashMap.get(stringArray[n]) != null) {
                Object[] objectArray = new String[]{stringArray[n], string};
                String string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_ONLY_WITH", null, objectArray);
                throw new RequiredParameterException(string2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        this.sshSetting = null;
        this.websmSetting = null;
        this.xntpSetting = null;
        this.httpSetting = null;
        this.syslogSetting = null;
        this.kbdcfgSetting = null;
        this.addConfig = false;
        this.removeConfig = false;
        string2 = (String)hashMap.get(HMCCommandUtils.CONFIG_PARAM);
        if (string2 != null) {
            string2 = string2.trim().toLowerCase();
        }
        if ((string3 = (String)hashMap.get(HMCCommandUtils.STATE_PARAM)) != null) {
            string3 = string3.trim().toLowerCase();
        }
        if (string2 == null || string3 == null) {
            Object[] objectArray = new String[]{HMCCommandUtils.CONFIG_PARAM + ", " + HMCCommandUtils.STATE_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
        n = 2;
        if (string2.equals(SSH_PARAM)) {
            if (!string3.equals(ENABLE_PARAM) && !string3.equals(DISABLE_PARAM)) {
                Object[] objectArray = new String[]{HMCCommandUtils.STATE_PARAM, "enable, disable"};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string);
            }
            this.sshSetting = new Boolean(string3.equals(ENABLE_PARAM));
            this.checkInvalidCombination(hashMap, MODIFY_PARAMS, HMCCommandUtils.STATE_PARAM + " " + MODIFY_PARAM);
            this.checkInvalidCombination(hashMap, ADD_REMOVE_PARAMS, HMCCommandUtils.STATE_PARAM + " " + ADD_PARAM + "|" + REMOVE_PARAM);
        } else if (string2.equals(NETWORK_PARAM)) {
            if (string3.equals(ADD_PARAM) || string3.equals(REMOVE_PARAM)) {
                int n2 = n;
                if (string3.equals(ADD_PARAM)) {
                    this.addConfig = true;
                } else {
                    this.removeConfig = true;
                }
                this.nameserver = (String)hashMap.get(HMCCommandUtils.NAMESERVER_PARAM);
                if (this.nameserver != null) {
                    this.nameserver = this.nameserver.trim();
                    ++n;
                }
                this.domainsuffix = (String)hashMap.get(HMCCommandUtils.DOMAINSUFFIX_PARAM);
                if (this.domainsuffix != null) {
                    this.domainsuffix = this.domainsuffix.trim();
                    ++n;
                }
                if (n == n2) {
                    Object[] objectArray = new String[]{HMCCommandUtils.NAMESERVER_PARAM + ", " + HMCCommandUtils.DOMAINSUFFIX_PARAM};
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SPECIFY_ONE_OR_MORE", null, objectArray);
                    throw new RequiredParameterException(string);
                }
                this.checkInvalidCombination(hashMap, MODIFY_PARAMS, HMCCommandUtils.STATE_PARAM + " " + MODIFY_PARAM);
            } else {
                if (!string3.equals(MODIFY_PARAM)) {
                    Object[] objectArray = new String[]{HMCCommandUtils.STATE_PARAM, "add, modify, remove"};
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                    throw new RequiredParameterException(string);
                }
                int n3 = n++;
                this.ifnum = (String)hashMap.get(HMCCommandUtils.INTERFACE_PARAM);
                if (this.ifnum != null) {
                    if (this.ifnum.trim().equals(ETH0_PARAM)) {
                        this.interfaceNum = 0;
                    } else {
                        if (!this.ifnum.trim().equals(ETH1_PARAM)) {
                            Object[] objectArray = new String[]{HMCCommandUtils.INTERFACE_PARAM, "eth0, eth1"};
                            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                            throw new RequiredParameterException(string);
                        }
                        this.interfaceNum = 1;
                    }
                    this.ipaddr = (String)hashMap.get(HMCCommandUtils.IPADDR_PARAM);
                    if (this.ipaddr != null) {
                        ++n;
                    }
                    this.netmask = (String)hashMap.get(HMCCommandUtils.NETMASK_PARAM);
                    if (this.netmask != null) {
                        ++n;
                    }
                    if (this.ipaddr == null && this.netmask == null) {
                        Object[] objectArray = new String[]{HMCCommandUtils.IPADDR_PARAM + ", " + HMCCommandUtils.NETMASK_PARAM};
                        string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SPECIFY_ONE_OR_MORE", null, objectArray);
                        throw new RequiredParameterException(string);
                    }
                } else {
                    this.checkInvalidCombination(hashMap, IF_PARAMS, HMCCommandUtils.INTERFACE_PARAM);
                }
                this.hostname = (String)hashMap.get(HMCCommandUtils.HOSTNAME_PARAM);
                if (this.hostname != null) {
                    ++n;
                }
                this.domainname = (String)hashMap.get(HMCCommandUtils.DOMAINNAME_PARAM);
                if (this.domainname != null) {
                    ++n;
                }
                this.gateway = (String)hashMap.get(HMCCommandUtils.GATEWAY_PARAM);
                if (this.gateway != null) {
                    ++n;
                }
                if (n == n3) {
                    Object[] objectArray = new String[]{HMCCommandUtils.INTERFACE_PARAM + ", " + HMCCommandUtils.HOSTNAME_PARAM + ", " + HMCCommandUtils.DOMAINNAME_PARAM + ", " + HMCCommandUtils.GATEWAY_PARAM};
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SPECIFY_ONE_OR_MORE", null, objectArray);
                    throw new RequiredParameterException(string);
                }
                this.checkInvalidCombination(hashMap, ADD_REMOVE_PARAMS, HMCCommandUtils.STATE_PARAM + " " + ADD_PARAM + "|" + REMOVE_PARAM);
            }
        } else if (string2.equals(HTTP_PARAM)) {
            if (!string3.equals(ENABLE_PARAM) && !string3.equals(DISABLE_PARAM)) {
                Object[] objectArray = new String[]{HMCCommandUtils.STATE_PARAM, "enable, disable"};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string);
            }
            this.httpSetting = new Boolean(string3.equals(ENABLE_PARAM));
            this.checkInvalidCombination(hashMap, MODIFY_PARAMS, HMCCommandUtils.STATE_PARAM + " " + MODIFY_PARAM);
            this.checkInvalidCombination(hashMap, ADD_REMOVE_PARAMS, HMCCommandUtils.STATE_PARAM + " " + ADD_PARAM + "|" + REMOVE_PARAM);
        } else if (string2.equals(WEBSM_PARAM)) {
            if (!string3.equals(ENABLE_PARAM) && !string3.equals(DISABLE_PARAM)) {
                Object[] objectArray = new String[]{HMCCommandUtils.STATE_PARAM, "enable, disable"};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string);
            }
            this.websmSetting = new Boolean(string3.equals(ENABLE_PARAM));
            this.checkInvalidCombination(hashMap, MODIFY_PARAMS, HMCCommandUtils.STATE_PARAM + " " + MODIFY_PARAM);
            this.checkInvalidCombination(hashMap, ADD_REMOVE_PARAMS, HMCCommandUtils.STATE_PARAM + " " + ADD_PARAM + "|" + REMOVE_PARAM);
        } else if (string2.equals(SYSLOG_PARAM)) {
            if (!string3.equals(ADD_PARAM) && !string3.equals(REMOVE_PARAM)) {
                Object[] objectArray = new String[]{HMCCommandUtils.STATE_PARAM, "add, modify, remove"};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string);
            }
            this.syslogSetting = new Boolean(true);
            if (string3.equals(ADD_PARAM)) {
                this.addConfig = true;
            } else {
                this.removeConfig = true;
            }
            this.ipaddr = (String)hashMap.get(HMCCommandUtils.IPADDR_PARAM);
            this.hostname = (String)hashMap.get(HMCCommandUtils.HOSTNAME_PARAM);
            if (this.ipaddr != null && this.hostname != null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYSLOG_PARAMETER", "Cannot specify both IP address and hostName");
                throw new RequiredParameterException(string);
            }
            ++n;
        } else if (string2.equals(KBDCFG_PARAM)) {
            if (!string3.equals(ENABLE_PARAM) && !string3.equals(DISABLE_PARAM)) {
                Object[] objectArray = new String[]{HMCCommandUtils.STATE_PARAM, "enable, disable"};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string);
            }
            this.kbdcfgSetting = new Boolean(string3.equals(ENABLE_PARAM));
            this.checkInvalidCombination(hashMap, MODIFY_PARAMS, HMCCommandUtils.STATE_PARAM + " " + MODIFY_PARAM);
            this.checkInvalidCombination(hashMap, ADD_REMOVE_PARAMS, HMCCommandUtils.STATE_PARAM + " " + ADD_PARAM + "|" + REMOVE_PARAM);
        } else {
            if (!string2.equals(XNTP_PARAM)) {
                Object[] objectArray = new String[]{HMCCommandUtils.CONFIG_PARAM, "ssh, network"};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string);
            }
            if (string3.equals(ADD_PARAM) || string3.equals(REMOVE_PARAM)) {
                this.xntpSetting = new Boolean(true);
                if (string3.equals(ADD_PARAM)) {
                    this.addConfig = true;
                } else {
                    this.removeConfig = true;
                }
                this.ipaddr = (String)hashMap.get(HMCCommandUtils.IPADDR_PARAM);
                this.hostname = (String)hashMap.get(HMCCommandUtils.HOSTNAME_PARAM);
                this.ntpversion = (String)hashMap.get(HMCCommandUtils.NTPVERSION_PARAM);
                if (this.ntpversion != null) {
                    ++n;
                }
                if (this.ipaddr != null && this.hostname != null) {
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYSLOG_PARAMETER", "Cannot specify both IP address and hostName");
                    throw new RequiredParameterException(string);
                }
                ++n;
            } else {
                if (!string3.equals(ENABLE_PARAM) && !string3.equals(DISABLE_PARAM)) {
                    Object[] objectArray = new String[]{HMCCommandUtils.STATE_PARAM, "enable, disable"};
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                    throw new RequiredParameterException(string);
                }
                this.xntpSetting = new Boolean(string3.equals(ENABLE_PARAM));
                this.checkInvalidCombination(hashMap, MODIFY_PARAMS, HMCCommandUtils.STATE_PARAM + " " + MODIFY_PARAM);
                this.checkInvalidCombination(hashMap, ADD_REMOVE_PARAMS, HMCCommandUtils.STATE_PARAM + " " + ADD_PARAM + "|" + REMOVE_PARAM);
            }
        }
        HMCCommandUtils.checkParameterCount(hashMap, n);
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HMC_MODIFY_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        HMCModify hMCModify = new HMCModify();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                hMCModify.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    hMCModify.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                hMCModify.mapParameters(hashMap);
                hMCModify.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

